﻿var setting = {
	view: {
		addHoverDom: addHoverDom,
		removeHoverDom: removeHoverDom,
		selectedMulti: false
	},
	edit: {
		enable: true,
		editNameSelectAll: true,
		showRemoveBtn: showRemoveBtn,
		showRenameBtn: showRenameBtn,
		removeTitle:"删除",
		renameTitle:"重命名",
		drag: {
			isCopy: true,
			isMove: true,
			prev: true,
			next: true,
			inner: true
		},
		renameTitle:"重命名",
		//Ztree拖拽
		drag: {
			isCopy:true,
			isMove:true,
			prev: true,
			next: true,
			inner: true
		}
		},
	data: {
		simpleData: {
			enable: true
		}
	},
	callback: {
		beforeDrag: beforeDrag,
		beforeDrop: beforeDrop,
		beforeEditName: beforeEditName,
		beforeRemove: beforeRemove,
		beforeRename: beforeRename,
		onRemove: onRemove,
		onRename: onRename,
		onDrop: onDrop
	}
};
var zNodes;
var oldName;
var log, className = "dark";
$(function() {

	$.post(baseUrl + "/admin/U030/findAll.html", {},function(data){
	zNodes = data;
	$.fn.zTree.init($("#treeDemo"), setting, zNodes);
	
	},"json");
});
function beforeDrag(treeId, treeNodes) {
	for (var i=0,l=treeNodes.length; i<l; i++) {
		if (treeNodes[i].drag === false) {
			return false;
		}
	}
	return true;
}

function beforeDrop(treeId, treeNodes, targetNode, moveType) {
	return true;
}


function beforeDrop(treeId, treeNodes, targetNode, moveType) {
	var tree = $.fn.zTree.getZTreeObj("treeDemo");
	var nodes = tree.transformToArray(tree.getNodes());
	var str = "";
	for(var obj in nodes)
	{
		var id      = nodes[obj]['id'];
		var pid     = nodes[obj]['pId'];
		var name    = nodes[obj]['name'];
		var sort    = nodes[obj]['sort'];
		if(id == 0) continue;
		str += id+"*";
		str += pid+"*";
		str += name+"#";
		str += sort+"#";
	}
	$.post("U030move.html",{"groups":str},function(data){
		
	});
}

function onDrop(event, treeId, treeNodes, targetNode, moveType, isCopy) {
	$.ajaxSetup({
		async:false
	});
	var tree = $.fn.zTree.getZTreeObj("treeDemo");
	var nodes = tree.transformToArray(tree.getNodes());
	var str = "";
	for(var obj in nodes)
	{
		var id = nodes[obj]['id'];
		var pid = nodes[obj]['pId'];
		var name = nodes[obj]['name'];
		if(id == 0) continue;
		var temp = "";
		temp += id+"*";
		temp += pid+"*";
		temp += name+"#";
		str += temp;
	}
	$.post("move.html",{"groups":str},function(data){
		if(data==null || data==''){
			alert("分类名字已存在！");
			//ztree刷新
			$.post(baseUrl + "/admin/U030/findAll.html", {},function(data){
				zNodes = data;
				$.fn.zTree.init($("#treeDemo"), setting, zNodes);
				
			},"json");
			return false;
		}
	});
	return targetNode ? targetNode.drop !== false : true;
}

function beforeEditName(treeId, treeNode) {
	className = (className === "dark" ? "":"dark");
	showLog("[ "+getTime()+" beforeEditName ]&nbsp;&nbsp;&nbsp;&nbsp; " + treeNode.name);
	oldName = treeNode.name;
	var zTree = $.fn.zTree.getZTreeObj("treeDemo");
	zTree.selectNode(treeNode);
	return true;
}
function beforeRemove(treeId, treeNode) {
	className = (className === "dark" ? "":"dark");
	showLog("[ "+getTime()+" beforeRemove ]&nbsp;&nbsp;&nbsp;&nbsp; " + treeNode.name);
	var zTree = $.fn.zTree.getZTreeObj("treeDemo");
	zTree.selectNode(treeNode);
	return confirm("确认删除 用户组 -- " + treeNode.name + " 吗？该用户组的子组将全部删除。");
}
// 删除子节点
function onRemove(e, treeId, treeNode) {
	$.ajaxSetup({
		async:false
	});
	$.post("delete.html",{"groupid":treeNode.id},function(data){
		if(data == -1){
			alert("总分类不能删除！");
			//刷新
			$.post(baseUrl + "/admin/U030/findAll.html", {},function(data){
				zNodes = data;
				$.fn.zTree.init($("#treeDemo"), setting, zNodes);
				
				},"json");
		}else if(data == -2){
			alert("该用户组或其子组下存在用户，不能删除！");
			//刷新
			$.post(baseUrl + "/admin/U030/findAll.html", {},function(data){
				zNodes = data;
				$.fn.zTree.init($("#treeDemo"), setting, zNodes);
				
				},"json");
		}else{
			showLog("[ "+getTime()+" onRemove ]&nbsp;&nbsp;&nbsp;&nbsp; " + treeNode.name);
		}
	});
}
function beforeRename(treeId, treeNode, newName, isCancel) {
	className = (className === "dark" ? "":"dark");
	oldName = treeNode.name;
	var treeObj = $.fn.zTree.getZTreeObj("treeDemo");
	showLog((isCancel ? "<span style='color:red'>":"") + "[ "+getTime()+
	" beforeRename ]&nbsp;&nbsp;&nbsp;&nbsp; " + treeNode.name + (isCancel ? "</span>":""));
	if (newName.length == 0) {
		alert("用户组名称不能为空.");
		$.post(baseUrl + "/admin/U030/findAll.html", {},function(data){
			zNodes = data;
			$.fn.zTree.init($("#treeDemo"), setting, zNodes);
		},"json");
// 				var zTree = $.fn.zTree.getZTreeObj("treeDemo");
// 				setTimeout(function(){zTree.editName(treeNode);}, 10);
		return false;
	}else if(newName.length > 50){
		alert("请使用1-50字符长度名称.");
		$.post(baseUrl + "/admin/U030/findAll.html", {},function(data){
			zNodes = data;
			$.fn.zTree.init($("#treeDemo"), setting, zNodes);
		},"json");
// 				var zTree = $.fn.zTree.getZTreeObj("treeDemo");
// 				setTimeout(function(){zTree.editName(treeNode);}, 10);
		return false;
	}
	return true;
}
//修改节点
function onRename(e, treeId, treeNode, isCancel) {
	$.ajaxSetup({
		async:false
	});
	var treeObj = $.fn.zTree.getZTreeObj("treeDemo");
	showLog((isCancel ? "<span style='color:red'>":"") + "[ "+getTime()+" onRename ]&nbsp;&nbsp;&nbsp;&nbsp; "+ treeNode.name + (isCancel ? "</span>":""));
	$.post("upd.html",{"groupid":treeNode.id,"groupname":treeNode.name},function(data){
		if(data == null || data == ""){
			alert("用户组重名！");
			treeNode.name = oldName;
			treeObj.updateNode(treeNode);
		}
		var zTree = $.fn.zTree.getZTreeObj("treeDemo");
		return false;
	});
	
}

function showRemoveBtn(treeId, treeNode) {
	
		
	if(treeNode.level>0){
		if(treeNode.tId=="treeDemo_2"){
			return false;
		}
		return true;
	}else{
		return false;
	}
}
function showRenameBtn(treeId, treeNode) {
	if(treeNode.level>0){
		return true;
	}else{
		return false;
	}
}
function showLog(str) {
	if (!log) log = $("#log");
	log.append("<li class='"+className+"'>"+str+"</li>");
	if(log.children("li").length > 8) {
		log.get(0).removeChild(log.children("li")[0]);
	}
}
function getTime() {
	var now= new Date(),
	h=now.getHours(),
	m=now.getMinutes(),
	s=now.getSeconds(),
	ms=now.getMilliseconds();
	return (h+":"+m+":"+s+ " " +ms);
}	
//添加节点
var newCount = 0;
function addHoverDom(treeId, treeNode) {
	var sObj = $("#" + treeNode.tId + "_span");
	if (treeNode.editNameFlag || $("#addBtn_"+treeNode.tId).length>0) return;
	var addStr = "<span class='button add' id='addBtn_" + treeNode.tId
		+ "' title='添加组' onfocus='this.blur();'></span>";
	sObj.after(addStr);
	var btn = $("#addBtn_"+treeNode.tId);
	if (btn) btn.bind("click", function(){
		$.post("add.html",{"groupid":treeNode.id,"num":++newCount},function(data){
			if(data == -1){
				alert("用户组重名！");
				return false;
			}
			var id = data;
			var zTree = $.fn.zTree.getZTreeObj("treeDemo");
			zTree.addNodes(treeNode, {id:(id), groupid:treeNode.id, name:"新建组"+newCount});
			return false;
		});
	});
};
function removeHoverDom(treeId, treeNode) {
	$("#addBtn_"+treeNode.tId).unbind().remove();
};
function openNextMode(modeName, modeUrl) {
	window.parent.openTab(modeName, modeUrl);
}